<?php require_once 'config/database.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email History</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h3>Email History</h3>
                        <a href="index.php" class="btn btn-primary">Send New Email</a>
                    </div>
                    <div class="card-body">
                        <?php
                        try {
                            $stmt = $pdo->query("SELECT * FROM emails ORDER BY sent_at DESC");
                            $emails = $stmt->fetchAll(PDO::FETCH_ASSOC);
                            
                            if (count($emails) > 0):
                        ?>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>To</th>
                                        <th>Subject</th>
                                        <th>Message Preview</th>
                                        <th>Status</th>
                                        <th>Sent At</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($emails as $email): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($email['to_email']); ?></td>
                                        <td><?php echo htmlspecialchars($email['subject']); ?></td>
                                        <td><?php echo htmlspecialchars(substr($email['message'], 0, 50)) . '...'; ?></td>
                                        <td>
                                            <span class="badge <?php echo $email['status'] == 'sent' ? 'bg-success' : 'bg-danger'; ?>">
                                                <?php echo ucfirst($email['status']); ?>
                                            </span>
                                        </td>
                                        <td><?php echo date('M j, Y g:i A', strtotime($email['sent_at'])); ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php else: ?>
                        <div class="text-center">
                            <p class="text-muted">No emails sent yet.</p>
                            <a href="index.php" class="btn btn-primary">Send your first email</a>
                        </div>
                        <?php endif; ?>
                        <?php
                        } catch (PDOException $e) {
                            echo '<div class="alert alert-danger">Error loading email history: ' . $e->getMessage() . '</div>';
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>