<?php
require_once 'config/database.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $to_email = $_POST['to_email'];
    $subject = $_POST['subject'];
    $message = $_POST['message'];
    
    // Email headers
    $headers = array();
    $headers[] = 'From: SA-NPC Recruitment <recruitment@sa-npc.co.za>';
    $headers[] = 'Reply-To: recruitment@sa-npc.co.za';
    $headers[] = 'Content-Type: text/html; charset=UTF-8';
    $headers[] = 'X-Mailer: PHP/' . phpversion();
    
    // Convert message to HTML
    $html_message = nl2br(htmlspecialchars($message));
    
    try {
        // Use PHP's mail function
        $success = mail($to_email, $subject, $html_message, implode("\r\n", $headers));
        
        if ($success) {
            // Save to database
            $stmt = $pdo->prepare("INSERT INTO emails (to_email, subject, message, status) VALUES (?, ?, ?, 'sent')");
            $stmt->execute([$to_email, $subject, $message]);
            
            header('Location: index.php?status=success');
            exit;
        } else {
            throw new Exception('mail() function returned false');
        }
        
    } catch (Exception $e) {
        // Save failed attempt to database
        $stmt = $pdo->prepare("INSERT INTO emails (to_email, subject, message, status) VALUES (?, ?, ?, 'failed')");
        $stmt->execute([$to_email, $subject, $message]);
        
        header('Location: index.php?status=error&msg=' . urlencode($e->getMessage()));
        exit;
    }
} else {
    header('Location: index.php');
    exit;
}
?>