<?php
namespace PHPMailer\PHPMailer;

class PHPMailer {
    const ENCRYPTION_STARTTLS = 'tls';
    const ENCRYPTION_SMTPS = 'ssl';
    
    public $Host;
    public $SMTPAuth = false;
    public $Username;
    public $Password;
    public $SMTPSecure;
    public $Port = 25;
    public $Subject = '';
    public $Body = '';
    public $From = '';
    public $FromName = '';
    
    private $to = [];
    private $isHTML = false;
    private $isSMTP = false;
    
    public function __construct($exceptions = null) {}
    
    public function isSMTP() {
        $this->isSMTP = true;
    }
    
    public function isHTML($ishtml = true) {
        $this->isHTML = $ishtml;
    }
    
    public function setFrom($address, $name = '') {
        $this->From = $address;
        $this->FromName = $name;
    }
    
    public function addAddress($address, $name = '') {
        $this->to[] = ['address' => $address, 'name' => $name];
    }
    
    public function send() {
        if ($this->isSMTP) {
            return $this->sendViaSMTP();
        } else {
            return $this->sendViaMail();
        }
    }
    
    private function sendViaSMTP() {
        $socket = fsockopen($this->Host, $this->Port, $errno, $errstr, 30);
        if (!$socket) {
            throw new Exception("Could not connect to SMTP server: $errstr ($errno)");
        }
        
        // Read initial response
        $response = fgets($socket, 512);
        if (substr($response, 0, 3) != '220') {
            fclose($socket);
            throw new Exception("SMTP server error: $response");
        }
        
        // EHLO
        fwrite($socket, "EHLO " . $_SERVER['HTTP_HOST'] . "\r\n");
        $response = fgets($socket, 512);
        
        // STARTTLS if required
        if ($this->SMTPSecure === self::ENCRYPTION_STARTTLS) {
            fwrite($socket, "STARTTLS\r\n");
            $response = fgets($socket, 512);
            if (substr($response, 0, 3) != '220') {
                fclose($socket);
                throw new Exception("STARTTLS failed: $response");
            }
        }
        
        // Authentication
        if ($this->SMTPAuth) {
            fwrite($socket, "AUTH LOGIN\r\n");
            $response = fgets($socket, 512);
            if (substr($response, 0, 3) != '334') {
                fclose($socket);
                throw new Exception("AUTH LOGIN failed: $response");
            }
            
            fwrite($socket, base64_encode($this->Username) . "\r\n");
            $response = fgets($socket, 512);
            if (substr($response, 0, 3) != '334') {
                fclose($socket);
                throw new Exception("Username authentication failed: $response");
            }
            
            fwrite($socket, base64_encode($this->Password) . "\r\n");
            $response = fgets($socket, 512);
            if (substr($response, 0, 3) != '235') {
                fclose($socket);
                throw new Exception("Password authentication failed: $response");
            }
        }
        
        // Send email for each recipient
        foreach ($this->to as $recipient) {
            // MAIL FROM
            fwrite($socket, "MAIL FROM: <" . $this->From . ">\r\n");
            $response = fgets($socket, 512);
            if (substr($response, 0, 3) != '250') {
                fclose($socket);
                throw new Exception("MAIL FROM failed: $response");
            }
            
            // RCPT TO
            fwrite($socket, "RCPT TO: <" . $recipient['address'] . ">\r\n");
            $response = fgets($socket, 512);
            if (substr($response, 0, 3) != '250') {
                fclose($socket);
                throw new Exception("RCPT TO failed: $response");
            }
            
            // DATA
            fwrite($socket, "DATA\r\n");
            $response = fgets($socket, 512);
            if (substr($response, 0, 3) != '354') {
                fclose($socket);
                throw new Exception("DATA command failed: $response");
            }
            
            // Email headers and body
            $headers = "From: " . ($this->FromName ? $this->FromName . " <" . $this->From . ">" : $this->From) . "\r\n";
            $headers .= "To: " . $recipient['address'] . "\r\n";
            $headers .= "Subject: " . $this->Subject . "\r\n";
            if ($this->isHTML) {
                $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
            }
            $headers .= "\r\n";
            
            fwrite($socket, $headers . $this->Body . "\r\n.\r\n");
            $response = fgets($socket, 512);
            if (substr($response, 0, 3) != '250') {
                fclose($socket);
                throw new Exception("Email sending failed: $response");
            }
        }
        
        // QUIT
        fwrite($socket, "QUIT\r\n");
        fclose($socket);
        
        return true;
    }
    
    private function sendViaMail() {
        $headers = [];
        $headers[] = 'From: ' . ($this->FromName ? $this->FromName . ' <' . $this->From . '>' : $this->From);
        if ($this->isHTML) {
            $headers[] = 'Content-Type: text/html; charset=UTF-8';
        }
        
        foreach ($this->to as $recipient) {
            $success = mail($recipient['address'], $this->Subject, $this->Body, implode("\r\n", $headers));
            if (!$success) {
                throw new Exception('Failed to send email via mail()');
            }
        }
        return true;
    }
}
?>