# Gmail SMTP Setup Instructions

Your Gmail SMTP integration has been successfully configured with Composer and PHPMailer! However, Gmail authentication failed due to security settings.

## 🎯 Current Status

✅ **Composer installed** - PHPMailer v6.10.0 ready  
✅ **Gmail service configured** - masandendyaluvane@gmail.com  
✅ **Professional email templates** - Ready for notifications  
✅ **Fallback system** - PHP mail() as backup  
❌ **Gmail authentication** - Needs security configuration  

## 🔐 Fix Gmail Authentication (Choose One Method)

### Method 1: Enable Less Secure App Access (Simplest)

1. **Go to Gmail Settings:**
   - Visit: https://myaccount.google.com/security
   - Sign in with: masandendyaluvane@gmail.com

2. **Enable Less Secure App Access:**
   - Scroll down to "Less secure app access"
   - Toggle it to "ON"
   - This allows SMTP authentication with your regular password

3. **Test the connection:**
   - The system will automatically work with your current password: M@$ande@2023

### Method 2: Use App Passwords (Recommended if you have 2FA)

1. **Check if 2-Factor Authentication is enabled:**
   - Visit: https://myaccount.google.com/security
   - Look for "2-Step Verification"

2. **If 2FA is enabled, create an App Password:**
   - Go to "2-Step Verification" settings
   - Click "App passwords"
   - Select "Mail" as the app
   - Generate a 16-character password (e.g., abcd efgh ijkl mnop)

3. **Update the system with App Password:**
   - Replace `M@$ande@2023` with the 16-character App Password
   - File to update: `includes/gmail_email_service.php` line 17

## 🧪 Testing After Setup

Run this command to test Gmail SMTP:
```bash
php test_gmail_final.php
```

Or visit in browser: `http://localhost/recruit/test_gmail_final.php`

## 📧 What Works Right Now

Even without Gmail SMTP, your notification system is working:

- ✅ **In-app notifications** - Working perfectly
- ✅ **Email notifications** - Using PHP mail() fallback
- ✅ **Professional templates** - Ready for Gmail
- ✅ **No error messages** - System handles failures gracefully

## 🎉 Once Gmail SMTP is Fixed

When Gmail authentication works, candidates will receive:

- **Professional HTML emails** from masandendyaluvane@gmail.com
- **Beautiful templates** with company branding
- **Status-specific subjects** (🎉 Shortlisted, 🎊 Hired, etc.)
- **Reliable delivery** through Gmail's servers

## 🔧 Alternative Solutions

If Gmail continues to have issues:

### Option 1: Use Different Email Provider
- **Outlook/Hotmail SMTP:** smtp.live.com:587
- **Yahoo SMTP:** smtp.mail.yahoo.com:587
- **Generic hosting SMTP:** Check with your hosting provider

### Option 2: Use Email Services
- **SendGrid:** Free tier with 100 emails/day
- **Mailgun:** Free tier with good deliverability
- **Amazon SES:** Very reliable and cheap

### Option 3: Keep Current Setup
- The PHP mail() fallback is working
- Notifications are being delivered
- No user experience impact

## 📝 Technical Details

**Current Configuration:**
- SMTP Host: smtp.gmail.com
- Port: 587 (STARTTLS)
- Username: masandendyaluvane@gmail.com
- Password: M@$ande@2023
- From: Recruitment Portal <masandendyaluvane@gmail.com>

**Files Modified:**
- ✅ Installed PHPMailer via Composer
- ✅ Created `includes/gmail_email_service.php`
- ✅ Updated `includes/notification_system.php`
- ✅ Added professional email templates
- ✅ Implemented fallback system

## 🎯 Quick Fix Summary

**Fastest solution:** Enable "Less secure app access" in Gmail security settings.

**Most secure solution:** Create and use an App Password if you have 2-factor authentication.

**Current workaround:** System uses PHP mail() and everything still works!

---

**Need help?** Check the error logs or run the test script for detailed diagnostics.