<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

echo "<h1>🧪 Create Test Pending Candidate for Approval Testing</h1>";

// Create a test pending candidate or change existing one to pending
$stmt = $db->prepare("
    UPDATE candidates 
    SET hr_approval_status = 'pending', hr_approval_date = NULL, hr_approval_notes = NULL 
    WHERE email = 'test@company.com' AND candidate_type = 'internal'
");

$result = $stmt->execute();

if ($result && $stmt->rowCount() > 0) {
    echo "<div style='background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "<h3>✅ Test Candidate Created Successfully!</h3>";
    echo "<p><strong>Test Employee</strong> is now in <strong>PENDING</strong> status.</p>";
    echo "<p><strong>Next Steps:</strong></p>";
    echo "<ol>";
    echo "<li>Go to Admin Dashboard → Internal Candidates</li>";
    echo "<li>Or go to Company Dashboard → Internal Employees</li>";
    echo "<li>You should see 'Test Employee' with status 'Pending'</li>";
    echo "<li>Click 'Approve' button</li>";
    echo "<li>Check if email is sent to: <strong>test@company.com</strong></li>";
    echo "</ol>";
    echo "</div>";
    
    // Show current status
    $check_stmt = $db->prepare("SELECT first_name, last_name, email, hr_approval_status FROM candidates WHERE email = 'test@company.com'");
    $check_stmt->execute();
    $candidate = $check_stmt->fetch();
    
    if ($candidate) {
        echo "<h3>📋 Current Test Candidate Status</h3>";
        echo "<table border='1' cellpadding='8' style='border-collapse: collapse;'>";
        echo "<tr style='background: #f0f0f0;'><th>Name</th><th>Email</th><th>Status</th></tr>";
        echo "<tr>";
        echo "<td>{$candidate['first_name']} {$candidate['last_name']}</td>";
        echo "<td>{$candidate['email']}</td>";
        echo "<td style='color: orange; font-weight: bold;'>PENDING</td>";
        echo "</tr>";
        echo "</table>";
    }
    
    echo "<h3>🎯 How to Test</h3>";
    echo "<div style='background: #f8f9fa; padding: 15px; border: 1px solid #dee2e6; border-radius: 5px;'>";
    echo "<p><strong>Option 1: Test via Admin Interface</strong></p>";
    echo "<ol>";
    echo "<li>Login as admin</li>";
    echo "<li>Go to: <a href='admin/internal-candidates.php'>admin/internal-candidates.php</a></li>";
    echo "<li>Find 'Test Employee' in pending list</li>";
    echo "<li>Click 'Approve' and check email</li>";
    echo "</ol>";
    
    echo "<p><strong>Option 2: Test via Company Interface</strong></p>";
    echo "<ol>";
    echo "<li>Login as company user</li>";
    echo "<li>Go to: <a href='company/internal-employees.php'>company/internal-employees.php</a></li>";
    echo "<li>Find 'Test Employee' in pending list</li>";
    echo "<li>Click 'Approve' and check email</li>";
    echo "</ol>";
    echo "</div>";
    
} else {
    echo "<div style='background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px;'>";
    echo "❌ Failed to create test candidate. Candidate may not exist or already pending.";
    echo "</div>";
}

echo "<style>
body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; }
table { width: 100%; margin: 20px 0; }
th, td { padding: 10px; text-align: left; border: 1px solid #ddd; }
th { background-color: #f2f2f2; }
h1, h2, h3 { color: #333; }
a { color: #007bff; text-decoration: none; }
a:hover { text-decoration: underline; }
</style>";
?>