<?php
require_once 'config/config.php';

echo "<h2>🔍 Debug Brian's Session Data</h2>\n";

// Start session
session_start();

echo "<h3>1. Current Session Data</h3>\n";
echo "<pre>";
print_r($_SESSION);
echo "</pre>\n";

// Manually set Brian's session for testing
echo "<h3>2. Manually Setting Brian's Session for Testing</h3>\n";
$_SESSION['user_type'] = 'candidate';
$_SESSION['user_id'] = 14; // Brian's ID
$_SESSION['first_name'] = 'Brian vukile';
$_SESSION['last_name'] = 'Peter';
$_SESSION['user_email'] = 'brianvukile.peter@sa-npc.co.za';

echo "<p>✅ Set session data for Brian (ID: 14)</p>\n";

// Now test the jobs.php filtering with this session
$database = new Database();
$db = $database->getConnection();

echo "<h3>3. Testing Job Filtering with Brian's Session</h3>\n";

// Check if user is logged in correctly
$is_logged_in = isLoggedIn('candidate');
echo "<p><strong>isLoggedIn('candidate'):</strong> " . ($is_logged_in ? 'TRUE' : 'FALSE') . "</p>\n";

if ($is_logged_in) {
    echo "<p><strong>Session user_id:</strong> {$_SESSION['user_id']}</p>\n";
    
    // Get candidate data (from jobs.php logic)
    $stmt = $db->prepare("SELECT candidate_type, company_id FROM candidates WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $candidate_data = $stmt->fetch();
    
    if ($candidate_data) {
        echo "<p><strong>Database candidate_type:</strong> {$candidate_data['candidate_type']}</p>\n";
        echo "<p><strong>Database company_id:</strong> {$candidate_data['company_id']}</p>\n";
        
        if ($candidate_data['candidate_type'] === 'internal') {
            echo "<p>✅ Identified as internal candidate</p>\n";
            
            // Test the filtering
            $where_conditions = ["j.status = 'active'", "j.status != 'closed'", "c.status = 'approved'"];
            $where_conditions[] = "(j.deadline IS NULL OR j.deadline >= CURDATE())";
            $where_conditions[] = "(
                (j.job_visibility IN ('internal', 'both') AND j.company_id = ?) OR 
                (j.job_visibility IN ('external', 'both') AND j.company_id != ?)
            )";
            $params = [$candidate_data['company_id'], $candidate_data['company_id']];
            
            $where_clause = "WHERE " . implode(" AND ", $where_conditions);
            
            echo "<p><strong>Generated WHERE clause:</strong></p>\n";
            echo "<pre>" . htmlspecialchars($where_clause) . "</pre>\n";
            echo "<p><strong>Parameters:</strong> [" . implode(', ', $params) . "]</p>\n";
            
            // Execute the query
            $query = "
                SELECT j.id, j.title, j.job_visibility, j.company_id, c.name as company_name
                FROM jobs j 
                JOIN companies c ON j.company_id = c.id 
                $where_clause
                ORDER BY j.company_id, j.job_visibility
            ";
            
            $stmt = $db->prepare($query);
            $stmt->execute($params);
            $results = $stmt->fetchAll();
            
            echo "<h4>Jobs Brian Should See (" . count($results) . " total):</h4>\n";
            echo "<table border='1' cellpadding='5'>\n";
            echo "<tr><th>ID</th><th>Title</th><th>Visibility</th><th>Company</th><th>Should See?</th></tr>\n";
            
            $sanpc_external_found = 0;
            
            foreach ($results as $job) {
                $color = '';
                $should_see = '✅ YES';
                
                if ($job['company_id'] == 8 && $job['job_visibility'] == 'external') {
                    $color = 'style="background-color: #ffebee; color: #d32f2f;"';
                    $should_see = '❌ NO - Problem!';
                    $sanpc_external_found++;
                } elseif ($job['company_id'] == 8) {
                    $color = 'style="background-color: #e3f2fd;"';
                    $should_see = '✅ YES - Own company';
                } else {
                    $color = 'style="background-color: #f3e5f5;"';
                    $should_see = '✅ YES - Other company';
                }
                
                echo "<tr $color>";
                echo "<td>{$job['id']}</td>";
                echo "<td>" . substr($job['title'], 0, 40) . "...</td>";
                echo "<td>{$job['job_visibility']}</td>";
                echo "<td>{$job['company_name']} ({$job['company_id']})</td>";
                echo "<td>$should_see</td>";
                echo "</tr>\n";
            }
            echo "</table>\n";
            
            if ($sanpc_external_found > 0) {
                echo "<div style='background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 10px 0;'>\n";
                echo "<h4>🚨 ISSUE CONFIRMED!</h4>\n";
                echo "<p>Found $sanpc_external_found SANPC external-only jobs in the results.</p>\n";
                echo "<p>These should NOT appear for Brian!</p>\n";
                echo "</div>\n";
            } else {
                echo "<div style='background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 10px 0;'>\n";
                echo "<h4>✅ FILTERING WORKING!</h4>\n";
                echo "<p>No SANPC external-only jobs found in results.</p>\n";
                echo "</div>\n";
            }
            
        } else {
            echo "<p>❌ NOT identified as internal candidate</p>\n";
        }
    } else {
        echo "<p>❌ No candidate data found for user_id: {$_SESSION['user_id']}</p>\n";
    }
} else {
    echo "<p>❌ Not logged in as candidate</p>\n";
}

// Check if there are any SANPC external jobs at all
echo "<h3>4. Available SANPC External-Only Jobs</h3>\n";
$stmt = $db->query("
    SELECT j.id, j.title, j.job_visibility, j.status, j.deadline
    FROM jobs j 
    WHERE j.company_id = 8 AND j.job_visibility = 'external' AND j.status = 'active'
    AND (j.deadline IS NULL OR j.deadline >= CURDATE())
");
$sanpc_external_jobs = $stmt->fetchAll();

if ($sanpc_external_jobs) {
    echo "<p>Found " . count($sanpc_external_jobs) . " active SANPC external-only jobs:</p>\n";
    foreach ($sanpc_external_jobs as $job) {
        echo "<p>• <strong>{$job['title']}</strong> (ID: {$job['id']})</p>\n";
    }
} else {
    echo "<p>No active SANPC external-only jobs found</p>\n";
}

?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; }
table { width: 100%; margin: 20px 0; border-collapse: collapse; }
th, td { padding: 8px; text-align: left; border: 1px solid #ddd; }
th { background-color: #f2f2f2; }
h1, h2, h3, h4 { color: #333; }
pre { background: #f5f5f5; padding: 10px; border-radius: 4px; font-size: 12px; }
</style>