<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

echo "<h2>Debug Specific Users: Sisanda & Brian</h2>\n";

// Get exact user details
$emails = ['sisanda.mbodlela@sanpc.co.za', 'brianvukile.peter@sa-npc.co.za'];

foreach ($emails as $email) {
    echo "<h3>User: $email</h3>\n";
    
    $stmt = $db->prepare("SELECT * FROM candidates WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    
    if ($user) {
        echo "<h4>Account Details:</h4>\n";
        echo "<table border='1' cellpadding='5'>\n";
        echo "<tr><th>Field</th><th>Value</th></tr>\n";
        echo "<tr><td>ID</td><td>{$user['id']}</td></tr>\n";
        echo "<tr><td>Name</td><td>{$user['first_name']} {$user['last_name']}</td></tr>\n";
        echo "<tr><td>Email</td><td>{$user['email']}</td></tr>\n";
        echo "<tr><td>Candidate Type</td><td>{$user['candidate_type']}</td></tr>\n";
        echo "<tr><td>HR Approval Status</td><td>{$user['hr_approval_status']}</td></tr>\n";
        echo "<tr><td>Company ID</td><td>{$user['company_id']}</td></tr>\n";
        echo "<tr><td>Password Set</td><td>" . (!empty($user['password']) ? 'YES' : 'NO') . "</td></tr>\n";
        echo "<tr><td>Created</td><td>{$user['created_at']}</td></tr>\n";
        echo "</table>\n";
        
        // Get company details
        if ($user['company_id']) {
            $stmt = $db->prepare("SELECT name, status FROM companies WHERE id = ?");
            $stmt->execute([$user['company_id']]);
            $company = $stmt->fetch();
            
            echo "<h4>Company Details:</h4>\n";
            if ($company) {
                echo "<p><strong>Company:</strong> {$company['name']} (Status: {$company['status']})</p>\n";
            } else {
                echo "<p><strong>Company:</strong> NOT FOUND (ID: {$user['company_id']})</p>\n";
            }
        }
        
        // Test password verification with common passwords
        echo "<h4>Password Test:</h4>\n";
        $test_passwords = ['123456', 'password', 'Password123', 'password123', 'Sasol123', '123', 'admin'];
        
        echo "<p>Testing common passwords:</p>\n";
        echo "<ul>\n";
        foreach ($test_passwords as $test_pwd) {
            $is_valid = password_verify($test_pwd, $user['password']);
            $status = $is_valid ? '✅ MATCH' : '❌ No match';
            echo "<li>$test_pwd: $status</li>\n";
        }
        echo "</ul>\n";
        
        // Show password hash (first 20 chars)
        echo "<p><strong>Password Hash (partial):</strong> " . substr($user['password'], 0, 20) . "...</p>\n";
        
    } else {
        echo "<p><strong>❌ User not found with email: $email</strong></p>\n";
    }
    
    echo "<hr>\n";
}

// Check for duplicate records
echo "<h3>Checking for Duplicate Records</h3>\n";
$stmt = $db->prepare("SELECT email, COUNT(*) as count FROM candidates GROUP BY email HAVING count > 1");
$stmt->execute();
$duplicates = $stmt->fetchAll();

if ($duplicates) {
    echo "<p><strong>⚠️ Found duplicate email addresses:</strong></p>\n";
    echo "<table border='1' cellpadding='5'>\n";
    echo "<tr><th>Email</th><th>Count</th></tr>\n";
    foreach ($duplicates as $dup) {
        echo "<tr><td>{$dup['email']}</td><td>{$dup['count']}</td></tr>\n";
    }
    echo "</table>\n";
} else {
    echo "<p>✅ No duplicate emails found.</p>\n";
}
?>