<?php
// Simple runner script to execute dummy score generation
require_once 'config/config.php';

// Check if user is logged in as company or admin
if (!isLoggedIn('company') && !isLoggedIn('admin')) {
    die('Access denied. Please login as a company or admin user.');
}

echo "<style>
    body { font-family: Arial, sans-serif; margin: 20px; background: #f8f9fa; }
    .container { max-width: 800px; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    .btn { padding: 10px 20px; background: #007bff; color: white; text-decoration: none; border-radius: 4px; border: none; cursor: pointer; margin: 5px; }
    .btn:hover { background: #0056b3; }
    .btn-success { background: #28a745; }
    .btn-success:hover { background: #1e7e34; }
</style>";

echo "<div class='container'>";
echo "<h2>Generate Dummy Survey Scores</h2>";

// Check if script should run
if (isset($_POST['run_script'])) {
    echo "<div style='border: 1px solid #ddd; padding: 20px; background: #f8f9fa; margin: 20px 0;'>";
    
    // Include and execute the generation script
    ob_start();
    include 'generate_dummy_scores.php';
    $output = ob_get_clean();
    
    echo $output;
    echo "</div>";
    
    echo "<div style='margin-top: 20px;'>";
    echo "<a href='company/applications.php' class='btn btn-success'>View Applications with Scores</a> ";
    echo "<a href='run_dummy_scores.php' class='btn'>Run Again</a>";
    echo "</div>";
} else {
    // Show form to run the script
    echo "<p>This will generate realistic dummy survey scores for all applications that currently don't have scores.</p>";
    
    echo "<form method='POST' style='margin: 20px 0;'>";
    echo "<button type='submit' name='run_script' class='btn btn-success'>Generate Dummy Scores</button>";
    echo "</form>";
    
    echo "<div style='margin-top: 20px;'>";
    echo "<a href='company/applications.php' class='btn'>View Current Applications</a>";
    echo "</div>";
}

echo "</div>";
?>