<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

try {
    // Create notifications table
    $sql = "
    CREATE TABLE IF NOT EXISTS notifications (
        id INT PRIMARY KEY AUTO_INCREMENT,
        user_type ENUM('candidate', 'company', 'admin') NOT NULL,
        user_id INT NOT NULL,
        title VARCHAR(255) NOT NULL,
        message TEXT NOT NULL,
        type ENUM('info', 'success', 'warning', 'error') DEFAULT 'info',
        related_type ENUM('application', 'job', 'interview', 'general') DEFAULT 'general',
        related_id INT NULL,
        is_read BOOLEAN DEFAULT FALSE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        INDEX idx_user_notifications (user_type, user_id, is_read),
        INDEX idx_created_at (created_at)
    )";
    
    $db->exec($sql);
    echo "Notifications table created successfully.<br>";
    
    // Create email notifications log table
    $sql = "
    CREATE TABLE IF NOT EXISTS email_notifications (
        id INT PRIMARY KEY AUTO_INCREMENT,
        to_email VARCHAR(255) NOT NULL,
        subject VARCHAR(255) NOT NULL,
        message TEXT NOT NULL,
        status ENUM('pending', 'sent', 'failed') DEFAULT 'pending',
        sent_at TIMESTAMP NULL,
        error_message TEXT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        INDEX idx_status (status),
        INDEX idx_created_at (created_at)
    )";
    
    $db->exec($sql);
    echo "Email notifications table created successfully.<br>";
    
    echo "Notification system setup complete!";
    
} catch (PDOException $e) {
    echo "Error setting up notification system: " . $e->getMessage();
}
?>