<?php
// Test Composer PHPMailer with Gmail App Password
require_once 'vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

echo "<h1>📧 Testing Composer PHPMailer with Gmail App Password</h1>";

// Gmail App Password Configuration
$config = [
    'smtp_host' => 'smtp.gmail.com',
    'smtp_port' => 587,
    'smtp_username' => 'masandendyaluvane@gmail.com',
    'smtp_password' => 'kwcn czhz pzvb eico',
    'from_email' => 'masandendyaluvane@gmail.com',
    'from_name' => 'Recruitment Portal - Test'
];

echo "<h2>🔧 Configuration Details</h2>";
echo "<table border='1' cellpadding='8' style='border-collapse: collapse;'>";
echo "<tr style='background: #f0f0f0;'><th>Setting</th><th>Value</th></tr>";
echo "<tr><td>SMTP Host</td><td>{$config['smtp_host']}</td></tr>";
echo "<tr><td>SMTP Port</td><td>{$config['smtp_port']}</td></tr>";
echo "<tr><td>Username</td><td>{$config['smtp_username']}</td></tr>";
echo "<tr><td>App Password</td><td>" . substr($config['smtp_password'], 0, 4) . " **** **** ****</td></tr>";
echo "<tr><td>From Email</td><td>{$config['from_email']}</td></tr>";
echo "<tr><td>From Name</td><td>{$config['from_name']}</td></tr>";
echo "</table>";

// Test email sending
echo "<h2>🚀 Testing Email Sending</h2>";

try {
    $mail = new PHPMailer(true);
    
    // Server settings
    $mail->isSMTP();
    $mail->Host       = $config['smtp_host'];
    $mail->SMTPAuth   = true;
    $mail->Username   = $config['smtp_username'];
    $mail->Password   = $config['smtp_password'];
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port       = $config['smtp_port'];
    
    // Enable verbose debug output (remove in production)
    $mail->SMTPDebug = SMTP::DEBUG_CONNECTION;
    $mail->Debugoutput = function($str, $level) {
        echo "<div style='color: #666; font-family: monospace; font-size: 12px; margin: 2px 0;'>DEBUG: " . htmlspecialchars($str) . "</div>";
    };
    
    // Recipients
    $mail->setFrom($config['from_email'], $config['from_name']);
    $mail->addAddress('masandendyaluvane@gmail.com', 'Test Recipient');
    
    // Content
    $mail->isHTML(true);
    $mail->Subject = '✅ Composer PHPMailer Test - ' . date('Y-m-d H:i:s');
    
    $mail->Body = '
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <title>PHPMailer Test</title>
    </head>
    <body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333;">
        <div style="max-width: 600px; margin: 0 auto; padding: 20px;">
            <h1 style="color: #28a745; border-bottom: 3px solid #28a745; padding-bottom: 10px;">
                🎉 Composer PHPMailer Test Successful!
            </h1>
            
            <div style="background: #f8f9fa; padding: 20px; border-radius: 8px; margin: 20px 0;">
                <h3 style="color: #495057; margin-top: 0;">Test Details:</h3>
                <ul style="color: #6c757d;">
                    <li><strong>Sent via:</strong> Composer PHPMailer 6.8+</li>
                    <li><strong>SMTP Provider:</strong> Gmail (smtp.gmail.com:587)</li>
                    <li><strong>Authentication:</strong> Gmail App Password</li>
                    <li><strong>Encryption:</strong> STARTTLS</li>
                    <li><strong>Test Time:</strong> ' . date('Y-m-d H:i:s T') . '</li>
                </ul>
            </div>
            
            <div style="background: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 15px; border-radius: 5px;">
                <h4 style="margin-top: 0;">✅ Configuration Verified</h4>
                <p>This email confirms that your Gmail App Password (<code>kwcn czhz pzvb eico</code>) is working correctly with PHPMailer.</p>
                <p>The recruitment portal email notifications are now ready for production use!</p>
            </div>
            
            <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #dee2e6; color: #6c757d; font-size: 14px;">
                <p><strong>Recruitment Portal Email System</strong><br>
                Powered by Composer + PHPMailer + Gmail SMTP</p>
            </div>
        </div>
    </body>
    </html>';
    
    $mail->AltBody = 'Composer PHPMailer Test Successful! Gmail App Password is working correctly. Test time: ' . date('Y-m-d H:i:s T');
    
    $mail->send();
    
    echo "<div style='background: #d4edda; color: #155724; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
    echo "<h3>🎉 Email Sent Successfully!</h3>";
    echo "<p><strong>✅ Composer PHPMailer is working perfectly with Gmail App Password!</strong></p>";
    echo "<p><strong>📧 Sent to:</strong> masandendyaluvane@gmail.com</p>";
    echo "<p><strong>⏰ Time:</strong> " . date('Y-m-d H:i:s T') . "</p>";
    echo "<p><strong>🔐 Authentication:</strong> Gmail App Password (kwcn czhz pzvb eico)</p>";
    echo "</div>";
    
    echo "<h3>✅ System Status</h3>";
    echo "<ul style='color: #28a745; font-weight: bold;'>";
    echo "<li>✅ Composer autoloader working</li>";
    echo "<li>✅ PHPMailer 6.8+ installed and functional</li>";
    echo "<li>✅ Gmail SMTP connection established</li>";
    echo "<li>✅ App Password authentication successful</li>";
    echo "<li>✅ STARTTLS encryption enabled</li>";
    echo "<li>✅ HTML email rendering working</li>";
    echo "</ul>";
    
} catch (Exception $e) {
    echo "<div style='background: #f8d7da; color: #721c24; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
    echo "<h3>❌ Email Sending Failed</h3>";
    echo "<p><strong>Error:</strong> " . $e->getMessage() . "</p>";
    
    if ($e->getCode()) {
        echo "<p><strong>Error Code:</strong> " . $e->getCode() . "</p>";
    }
    
    echo "<h4>🔧 Troubleshooting Steps:</h4>";
    echo "<ol>";
    echo "<li>Verify Gmail App Password is still active</li>";
    echo "<li>Check if 2-factor authentication is enabled on Gmail account</li>";
    echo "<li>Ensure 'Less secure app access' is not required (App Passwords bypass this)</li>";
    echo "<li>Verify network connectivity to smtp.gmail.com:587</li>";
    echo "<li>Check XAMPP PHP OpenSSL extension is enabled</li>";
    echo "</ol>";
    echo "</div>";
}

// Test current recruitment portal email service
echo "<h2>🧪 Testing Recruitment Portal Email Service</h2>";

try {
    require_once 'config/config.php';
    require_once 'includes/gmail_email_service.php';
    
    $database = new Database();
    $db = $database->getConnection();
    $gmailService = new GmailEmailService($db);
    
    // Test with dummy candidate data
    $testCandidate = [
        'first_name' => 'Test',
        'last_name' => 'User',
        'email' => 'masandendyaluvane@gmail.com'
    ];
    
    $testMessage = "Dear Test User,\n\nThis is a test of the recruitment portal email system using Composer PHPMailer with Gmail App Password.\n\nBest regards,\nHR Team";
    
    $result = $gmailService->sendApprovalNotificationEmail($testCandidate, $testMessage, 'approve');
    
    if ($result) {
        echo "<div style='background: #d4edda; color: #155724; padding: 15px; border-radius: 5px;'>";
        echo "<h4>✅ Recruitment Portal Email Test Successful!</h4>";
        echo "<p>The integrated email system is working correctly with your Gmail App Password.</p>";
        echo "</div>";
    } else {
        echo "<div style='background: #fff3cd; color: #856404; padding: 15px; border-radius: 5px;'>";
        echo "<h4>⚠️ Recruitment Portal Email Test Warning</h4>";
        echo "<p>Direct PHPMailer test passed, but integrated service may have issues. Check error logs.</p>";
        echo "</div>";
    }
    
} catch (Exception $e) {
    echo "<div style='background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px;'>";
    echo "<h4>❌ Recruitment Portal Email Test Failed</h4>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
    echo "</div>";
}

echo "<style>
body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; }
table { width: 100%; margin: 20px 0; }
th, td { padding: 10px; text-align: left; border: 1px solid #ddd; }
th { background-color: #f2f2f2; }
h1, h2, h3 { color: #333; }
code { background: #f8f9fa; padding: 2px 4px; border-radius: 3px; }
</style>";
?>