<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

// Test CV generation for Rammy specifically
echo "Testing CV generation for Rammy Martin (ID: 12)\n";

// Get Rammy's application data
$stmt = $db->prepare("
    SELECT ja.id, ja.candidate_id, ja.resume_id, ja.cover_letter, ja.applied_at, ja.status, 
           COALESCE(ja.total_score, 0) as total_score,
           j.title as job_title, j.description as job_description,
           c.first_name, c.last_name, c.email, c.profile_picture,
           r.title as resume_title, r.file_path as resume_path
    FROM job_applications ja
    JOIN jobs j ON ja.job_id = j.id
    JOIN candidates c ON ja.candidate_id = c.id
    LEFT JOIN resumes r ON ja.resume_id = r.id
    WHERE ja.candidate_id = 12 AND j.title LIKE '%Business Development%'
");
$stmt->execute();
$app = $stmt->fetch();

if (!$app) {
    echo "No application found for Rammy\n";
    exit;
}

echo "Found application ID: {$app['id']}\n";
echo "Job: {$app['job_title']}\n";

// Get CV builder data manually 
function getCVBuilderData($db, $candidate_id) {
    $cv_data = ['has_data' => false];
    
    try {
        // Get education data
        $stmt = $db->prepare("SELECT * FROM education WHERE candidate_id = ? ORDER BY start_date DESC");
        $stmt->execute([$candidate_id]);
        $cv_data['education'] = $stmt->fetchAll();
        
        // Get work experience data
        $stmt = $db->prepare("SELECT * FROM work_experience WHERE candidate_id = ? ORDER BY start_date DESC");
        $stmt->execute([$candidate_id]);
        $cv_data['experience'] = $stmt->fetchAll();
        
        // Get references data
        try {
            $stmt = $db->prepare("SELECT * FROM work_references WHERE candidate_id = ? ORDER BY created_at DESC");
            $stmt->execute([$candidate_id]);
            $cv_data['references'] = $stmt->fetchAll();
        } catch (PDOException $e) {
            $cv_data['references'] = [];
        }
        
        // Check if we have any data
        if (!empty($cv_data['education']) || !empty($cv_data['experience']) || !empty($cv_data['references'])) {
            $cv_data['has_data'] = true;
        }
        
    } catch (PDOException $e) {
        error_log("CV Builder data error for candidate $candidate_id: " . $e->getMessage());
    }
    
    return $cv_data;
}

$cv_data = getCVBuilderData($db, $app['candidate_id']);
$app['cv_builder_data'] = $cv_data;

echo "CV Builder data available: " . ($cv_data['has_data'] ? 'YES' : 'NO') . "\n";
echo "Education records: " . count($cv_data['education']) . "\n";
echo "Experience records: " . count($cv_data['experience']) . "\n";
echo "References records: " . count($cv_data['references']) . "\n";

if ($cv_data['has_data']) {
    echo "\nTesting CV generation...\n";
    
    // Simple test CV generation function
    function generateSimpleCVText($app, $cv_data) {
        $candidate_name = trim(($app['first_name'] ?? '') . ' ' . ($app['last_name'] ?? ''));
        
        $content = "CV for $candidate_name\n";
        $content .= "==================\n\n";
        $content .= "Job Applied For: " . ($app['job_title'] ?? 'N/A') . "\n";
        $content .= "Application Date: " . ($app['applied_at'] ?? 'N/A') . "\n\n";
        
        // Add experience
        if (!empty($cv_data['experience'])) {
            $content .= "WORK EXPERIENCE:\n";
            foreach ($cv_data['experience'] as $exp) {
                $content .= "- " . ($exp['position'] ?? 'Position') . " at " . ($exp['company_name'] ?? 'Company') . "\n";
                $content .= "  " . ($exp['start_date'] ?? '') . " - " . ($exp['end_date'] ?? 'Present') . "\n";
                $content .= "  " . ($exp['description'] ?? '') . "\n\n";
            }
        }
        
        // Add education
        if (!empty($cv_data['education'])) {
            $content .= "EDUCATION:\n";
            foreach ($cv_data['education'] as $edu) {
                $content .= "- " . ($edu['degree'] ?? 'Degree') . " at " . ($edu['institution'] ?? 'Institution') . "\n";
                $content .= "  " . ($edu['start_date'] ?? '') . " - " . ($edu['end_date'] ?? '') . "\n\n";
            }
        }
        
        // Add references
        if (!empty($cv_data['references'])) {
            $content .= "REFERENCES:\n";
            foreach ($cv_data['references'] as $ref) {
                $content .= "- " . ($ref['name'] ?? 'Reference') . " - " . ($ref['position'] ?? '') . "\n";
                $content .= "  " . ($ref['company'] ?? '') . " - " . ($ref['email'] ?? '') . "\n\n";
            }
        }
        
        return $content;
    }
    
    $cv_text = generateSimpleCVText($app, $cv_data);
    echo "Generated CV text:\n";
    echo $cv_text;
    
    echo "\nCV generation test successful!\n";
} else {
    echo "No CV data to generate\n";
}
?>