<?php
// Test complete filter workflow
echo "Testing complete sidebar filter workflow...\n\n";

try {
    // Test 1: Test with no filters (default state)
    echo "🔍 Test 1: No filters applied\n";
    $_GET = [];
    ob_start();
    include 'jobs.php';
    $output = ob_get_contents();
    ob_end_clean();
    
    $no_filters_test = strpos($output, 'active-filters') === false;
    echo ($no_filters_test ? "✅" : "❌") . " No active filters section when no filters applied\n";
    
    // Test 2: Test with multiple filters
    echo "\n🔍 Test 2: Multiple filters applied\n";
    $_GET = [
        'keyword' => 'developer',
        'location' => 'Cape Town',
        'employment_type' => 'full-time',
        'experience_level' => 'mid',
        'salary_range' => '50000-80000'
    ];
    
    ob_start();
    include 'jobs.php';
    $output = ob_get_contents();
    ob_end_clean();
    
    $multi_filter_tests = [
        'Active filters section shown' => strpos($output, 'active-filters') !== false,
        'Keyword filter badge' => strpos($output, 'developer') !== false,
        'Location filter badge' => strpos($output, 'Cape Town') !== false,
        'Employment type filter badge' => strpos($output, 'Full time') !== false,
        'Experience level filter badge' => strpos($output, 'Mid Level') !== false,
        'Salary range filter badge' => strpos($output, 'Salary: R50000 - R80000') !== false,
        'Clear All button present' => strpos($output, 'Clear All') !== false,
        'Remove filter buttons present' => substr_count($output, 'btn-close') >= 5
    ];
    
    foreach ($multi_filter_tests as $test => $passed) {
        echo ($passed ? "✅" : "❌") . " {$test}\n";
    }
    
    // Test 3: Check JavaScript filter functions exist
    echo "\n🔍 Test 3: JavaScript filter functions\n";
    $js_tests = [
        'applyFilter function exists' => strpos($output, 'function applyFilter') !== false,
        'filterByCategory function exists' => strpos($output, 'function filterByCategory') !== false,
        'filterByType function exists' => strpos($output, 'function filterByType') !== false,
        'filterByExperience function exists' => strpos($output, 'function filterByExperience') !== false,
        'clearAllFilters function exists' => strpos($output, 'function clearAllFilters') !== false,
        'removeFilter function exists' => strpos($output, 'function removeFilter') !== false
    ];
    
    foreach ($js_tests as $test => $passed) {
        echo ($passed ? "✅" : "❌") . " {$test}\n";
    }
    
    // Test 4: Check sidebar onclick handlers
    echo "\n🔍 Test 4: Sidebar filter onclick handlers\n";
    $onclick_tests = [
        'Category filter onclick' => strpos($output, 'onclick="filterByCategory(') !== false,
        'Employment type onclick' => strpos($output, 'onclick="filterByType(') !== false,
        'Experience level onclick' => strpos($output, 'onclick="filterByExperience(') !== false,
        'Location filter onclick' => strpos($output, 'onclick="filterByLocation(') !== false
    ];
    
    foreach ($onclick_tests as $test => $passed) {
        echo ($passed ? "✅" : "❌") . " {$test}\n";
    }
    
    $all_passed = true;
    foreach (array_merge($multi_filter_tests, $js_tests, $onclick_tests) as $passed) {
        if (!$passed) {
            $all_passed = false;
            break;
        }
    }
    
    if ($all_passed && $no_filters_test) {
        echo "\n🎉 SUCCESS: All sidebar filter functionality is working correctly!\n";
        echo "📍 The sidebar filters now work with real data and provide:\n";
        echo "   • Dynamic URL-based filtering\n";
        echo "   • Active filter display with removal buttons\n";
        echo "   • Clear all filters functionality\n";
        echo "   • Proper parameter preservation\n";
        echo "   • Real-time filter counts from database\n";
    } else {
        echo "\n⚠️ Some filter tests failed. Check implementation.\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error testing filter workflow: " . $e->getMessage() . "\n";
}
?>