<?php
// Quick test to verify jobs.php loads without errors
echo "Testing jobs.php functionality...\n\n";

try {
    // Capture output instead of displaying directly
    ob_start();
    
    // Include the jobs page
    $_GET = []; // Clear any GET parameters
    include 'jobs.php';
    
    $output = ob_get_contents();
    ob_end_clean();
    
    // Check if output contains expected elements
    $tests = [
        'Page loads' => !empty($output),
        'Contains filter sidebar' => strpos($output, 'filter-sidebar') !== false,
        'Contains job cards' => strpos($output, 'job-card') !== false,
        'Contains search bar' => strpos($output, 'search-bar') !== false,
        'Contains results header' => strpos($output, 'results-header') !== false,
        'No PHP errors visible' => strpos($output, 'Fatal error') === false && strpos($output, 'Warning:') === false
    ];
    
    echo "✅ Test Results:\n";
    echo "================\n";
    foreach ($tests as $test => $passed) {
        echo ($passed ? "✅" : "❌") . " {$test}\n";
    }
    
    if (all_tests_passed($tests)) {
        echo "\n🎉 SUCCESS: Jobs page loads correctly with all filters!\n";
        echo "📍 You can now visit: http://localhost/recruit/jobs.php\n";
    } else {
        echo "\n⚠️ Some tests failed. Check the implementation.\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error testing jobs page: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . " | Line: " . $e->getLine() . "\n";
}

function all_tests_passed($tests) {
    foreach ($tests as $passed) {
        if (!$passed) return false;
    }
    return true;
}

echo "\n" . str_repeat("=", 50) . "\n";
echo "Database Column Fixes Applied:\n";
echo "• Company size filters now use name/description patterns\n";
echo "• Benefits filters now search description/requirements only\n";
echo "• All filters adapted to existing database schema\n";
echo "• Fallback counts provided for better user experience\n";
?>