<?php
require_once 'config/config.php';

echo "<h2>🔐 Test Login Functionality</h2>\n";

// Test credentials
$test_users = [
    [
        'email' => 'sisanda.mbodlela@sanpc.co.za',
        'password' => 'Sisanda123',
        'name' => 'Sisanda'
    ],
    [
        'email' => 'brianvukile.peter@sa-npc.co.za', 
        'password' => 'Brian123',
        'name' => 'Brian'
    ]
];

$database = new Database();
$db = $database->getConnection();

foreach ($test_users as $test_user) {
    echo "<h3>Testing: {$test_user['name']}</h3>\n";
    
    // Simulate the exact login process from auth/login.php
    $email = $test_user['email'];
    $password = $test_user['password'];
    $user_type = 'candidate';
    
    echo "<p><strong>Email:</strong> $email</p>\n";
    echo "<p><strong>Password:</strong> $password</p>\n";
    echo "<p><strong>User Type:</strong> $user_type</p>\n";
    
    // Get user from database
    $stmt = $db->prepare("SELECT * FROM candidates WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    
    if ($user) {
        echo "<p>✅ User found in database</p>\n";
        echo "<p><strong>DB ID:</strong> {$user['id']}</p>\n";
        echo "<p><strong>DB Name:</strong> {$user['first_name']} {$user['last_name']}</p>\n";
        echo "<p><strong>DB Type:</strong> {$user['candidate_type']}</p>\n";
        echo "<p><strong>DB Status:</strong> {$user['hr_approval_status']}</p>\n";
        
        // Test password verification
        $password_valid = password_verify($password, $user['password']);
        
        if ($password_valid) {
            echo "<p>✅ Password verification successful</p>\n";
            
            // Test internal candidate approval check
            if ($user['candidate_type'] === 'internal' && $user['hr_approval_status'] !== 'approved') {
                if ($user['hr_approval_status'] === 'pending') {
                    $stmt = $db->prepare("SELECT name FROM companies WHERE id = ?");
                    $stmt->execute([$user['company_id']]);
                    $company = $stmt->fetch();
                    $company_name = $company ? $company['name'] : 'your company';
                    
                    echo "<p>❌ Login would FAIL: Account pending approval from $company_name</p>\n";
                } elseif ($user['hr_approval_status'] === 'rejected') {
                    echo "<p>❌ Login would FAIL: Account rejected</p>\n";
                }
            } else {
                echo "<p>✅ Internal candidate approval check passed</p>\n";
                echo "<div style='background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 10px 0;'>\n";
                echo "<h4>🎉 LOGIN SHOULD WORK!</h4>\n";
                echo "<p>All checks passed. User should be able to log in successfully.</p>\n";
                echo "</div>\n";
            }
        } else {
            echo "<p>❌ Password verification failed</p>\n";
            echo "<p>Stored hash (first 30 chars): " . substr($user['password'], 0, 30) . "...</p>\n";
            
            // Test with other possible passwords
            $test_passwords = ['password123', 'Password123', 'brian123', 'sisanda123'];
            echo "<p>Testing other passwords:</p>\n";
            foreach ($test_passwords as $pwd) {
                if (password_verify($pwd, $user['password'])) {
                    echo "<p>✅ Password '$pwd' works!</p>\n";
                    break;
                }
            }
        }
    } else {
        echo "<p>❌ User not found in database</p>\n";
    }
    
    echo "<hr>\n";
}

echo "<h3>Summary</h3>\n";
echo "<div style='background: #f8f9fa; padding: 15px; border: 1px solid #dee2e6; border-radius: 5px;'>\n";
echo "<p><strong>Login Credentials:</strong></p>\n";
echo "<ul>\n";
echo "<li><strong>Sisanda:</strong> sisanda.mbodlela@sanpc.co.za / Sisanda123</li>\n";
echo "<li><strong>Brian:</strong> brianvukile.peter@sa-npc.co.za / Brian123</li>\n";
echo "</ul>\n";
echo "<p><strong>Login as:</strong> Job Seeker (Candidate)</p>\n";
echo "<p><a href='auth/login.php' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px;'>Test Login Now</a></p>\n";
echo "</div>\n";
?>