<?php
require_once 'config/config.php';
require_once 'includes/reliable_cv_generator.php';

echo "<!DOCTYPE html>
<html>
<head>
    <title>Smart Document Display Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f8f9fa; }
        .container { max-width: 1200px; background: white; padding: 20px; border-radius: 8px; }
        .success { color: #28a745; } .info { color: #007bff; } .warning { color: #ffc107; }
        .test-section { background: #f1f3f4; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #007bff; }
        .download-btn { background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px; margin: 5px; display: inline-block; }
        .sa-highlight { background: #e8f5e8; border: 2px solid #28a745; padding: 15px; border-radius: 8px; margin: 10px 0; }
        .foreign-highlight { background: #e3f2fd; border: 2px solid #2196f3; padding: 15px; border-radius: 8px; margin: 10px 0; }
        .comparison-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin: 20px 0; }
        table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        th, td { padding: 10px; border: 1px solid #ddd; text-align: left; }
        th { background: #f8f9fa; font-weight: bold; }
        .priority { background: #fff3cd; font-weight: bold; }
    </style>
</head>
<body>
<div class='container'>";

echo "<h1>🆔 Smart Document Display Test</h1>";
echo "<p>Testing intelligent document display: <strong>South African ID</strong> for SA nationals vs <strong>Passport Number</strong> for foreign nationals.</p>";

try {
    echo "<div class='test-section'>";
    echo "<h2>🎯 Test Scenarios Overview</h2>";
    echo "<p>Testing document display logic for different nationality scenarios:</p>";
    
    echo "<table>";
    echo "<tr><th>Nationality Type</th><th>Primary Document</th><th>Secondary Document</th><th>HR Benefit</th></tr>";
    echo "<tr><td><strong>South African</strong></td><td class='priority'>South African ID</td><td>Passport (if available)</td><td>Quick local verification</td></tr>";
    echo "<tr><td><strong>Foreign National</strong></td><td class='priority'>Passport Number</td><td>National ID (if available)</td><td>Work authorization assessment</td></tr>";
    echo "</table>";
    echo "</div>";
    
    // Test Case 1: South African candidate
    $sa_candidate = [
        'id' => 100,
        'first_name' => 'Thabo',
        'last_name' => 'Mthembu',
        'email' => 'thabo.mthembu@email.com',
        'nationality' => 'South African',
        'id_number' => '8503041234567',
        'passport_number' => 'SA123456789',
        'job_title' => 'Software Developer'
    ];
    
    // Test Case 2: Foreign national 
    $foreign_candidate = [
        'id' => 200,
        'first_name' => 'James',
        'last_name' => 'Anderson',
        'email' => 'james.anderson@email.com',
        'nationality' => 'British',
        'id_number' => 'UK987654321',
        'passport_number' => 'GB123456789',
        'job_title' => 'Project Manager'
    ];
    
    // Test Case 3: Another SA variation
    $sa_candidate_2 = [
        'id' => 300,
        'first_name' => 'Nomsa',
        'last_name' => 'Dlamini',
        'email' => 'nomsa.dlamini@email.com',
        'nationality' => 'South Africa', // Different format
        'id_number' => '9012051234568',
        'passport_number' => null, // No passport
        'job_title' => 'Business Analyst'
    ];
    
    // Test Case 4: Foreign national with no local ID
    $foreign_candidate_2 = [
        'id' => 400,
        'first_name' => 'Maria',
        'last_name' => 'Silva',
        'email' => 'maria.silva@email.com',
        'nationality' => 'Brazilian',
        'id_number' => null, // No local ID
        'passport_number' => 'BR987654321',
        'job_title' => 'Marketing Specialist'
    ];
    
    $test_cases = [
        ['candidate' => $sa_candidate, 'type' => 'South African', 'description' => 'SA candidate with both ID and passport'],
        ['candidate' => $foreign_candidate, 'type' => 'Foreign National', 'description' => 'British candidate with both documents'],
        ['candidate' => $sa_candidate_2, 'type' => 'South African', 'description' => 'SA candidate with only ID number'],
        ['candidate' => $foreign_candidate_2, 'type' => 'Foreign National', 'description' => 'Brazilian candidate with only passport']
    ];
    
    echo "<div class='comparison-grid'>";
    
    foreach ($test_cases as $index => $test_case) {
        $candidate = $test_case['candidate'];
        $type = $test_case['type'];
        $description = $test_case['description'];
        
        $highlight_class = ($type === 'South African') ? 'sa-highlight' : 'foreign-highlight';
        
        echo "<div class='{$highlight_class}'>";
        echo "<h3>" . ($type === 'South African' ? '🇿🇦' : '🌍') . " Test Case " . ($index + 1) . "</h3>";
        echo "<h4>{$candidate['first_name']} {$candidate['last_name']}</h4>";
        echo "<p><strong>Nationality:</strong> {$candidate['nationality']}</p>";
        echo "<p><em>{$description}</em></p>";
        
        // Basic CV data
        $cv_data = [
            'has_data' => true,
            'resume_summary' => 'Professional with experience in ' . strtolower($candidate['job_title']) . ' role.',
            'skills' => 'Communication, Problem Solving, Team Collaboration',
            'education' => [],
            'experience' => [],
            'certificates' => [],
            'references' => []
        ];
        
        $candidate['cv_builder_data'] = $cv_data;
        
        // Generate CV
        $cv_generator = new ReliableCVGenerator();
        $cv_result = $cv_generator->generateCV($candidate, $cv_data);
        
        if ($cv_result !== false && !empty($cv_result['content'])) {
            echo "<p class='success'>✅ CV generated successfully</p>";
            
            // Check what documents are displayed
            $cv_content = $cv_result['content'];
            $has_sa_id = strpos($cv_content, 'South African ID:') !== false;
            $has_passport = strpos($cv_content, 'Passport Number:') !== false || strpos($cv_content, 'Passport:') !== false;
            $has_national_id = strpos($cv_content, 'National ID:') !== false;
            
            echo "<h5>📋 Document Display Results:</h5>";
            echo "<ul>";
            
            if ($type === 'South African') {
                if ($has_sa_id) {
                    echo "<li class='success'>✅ <strong>South African ID displayed</strong> (Primary document)</li>";
                } else {
                    echo "<li style='color: red;'>❌ South African ID not displayed</li>";
                }
                
                if ($candidate['passport_number'] && $has_passport) {
                    echo "<li class='info'>ℹ️ Passport also shown (Secondary document)</li>";
                } elseif (!$candidate['passport_number']) {
                    echo "<li class='info'>ℹ️ No passport data available</li>";
                }
            } else {
                if ($has_passport) {
                    echo "<li class='success'>✅ <strong>Passport Number displayed</strong> (Primary document)</li>";
                } else {
                    echo "<li style='color: red;'>❌ Passport Number not displayed</li>";
                }
                
                if ($candidate['id_number'] && $has_national_id) {
                    echo "<li class='info'>ℹ️ National ID also shown (Secondary document)</li>";
                } elseif (!$candidate['id_number']) {
                    echo "<li class='info'>ℹ️ No national ID data available</li>";
                }
            }
            
            echo "</ul>";
            
            // Save test CV
            $test_cv_file = 'smart_doc_test_' . $candidate['first_name'] . '_' . $candidate['last_name'] . '_' . $cv_result['filename'];
            file_put_contents($test_cv_file, $cv_result['content']);
            
            echo "<p><a href='{$test_cv_file}' class='download-btn' target='_blank'>📄 View CV</a></p>";
            
        } else {
            echo "<p style='color: red;'>❌ CV generation failed</p>";
        }
        
        echo "</div>";
    }
    
    echo "</div>";
    
    // HR Benefits Summary
    echo "<div style='background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); border: 2px solid #6c757d; border-radius: 10px; padding: 25px; margin: 30px 0;'>";
    echo "<h2 style='color: #495057; margin-top: 0;'>👥 HR Document Display Benefits</h2>";
    
    echo "<div style='display: grid; grid-template-columns: 1fr 1fr; gap: 25px; margin: 20px 0;'>";
    
    echo "<div>";
    echo "<h3 style='color: #495057;'>🇿🇦 South African Candidates</h3>";
    echo "<div style='background: #e8f5e8; padding: 15px; border-radius: 8px; border-left: 5px solid #28a745;'>";
    echo "<h4 style='color: #155724;'>Primary: South African ID</h4>";
    echo "<ul style='color: #155724;'>";
    echo "<li><strong>Format:</strong> 13-digit SA ID number</li>";
    echo "<li><strong>Verification:</strong> Easy local verification</li>";
    echo "<li><strong>Information:</strong> Birth date, gender, citizenship encoded</li>";
    echo "<li><strong>HR Benefit:</strong> Quick identity confirmation</li>";
    echo "<li><strong>Work Authorization:</strong> Automatic right to work</li>";
    echo "</ul>";
    echo "</div>";
    echo "</div>";
    
    echo "<div>";
    echo "<h3 style='color: #495057;'>🌍 Foreign Nationals</h3>";
    echo "<div style='background: #e3f2fd; padding: 15px; border-radius: 8px; border-left: 5px solid #2196f3;'>";
    echo "<h4 style='color: #1565c0;'>Primary: Passport Number</h4>";
    echo "<ul style='color: #1565c0;'>";
    echo "<li><strong>Format:</strong> International passport identifier</li>";
    echo "<li><strong>Verification:</strong> Global travel document</li>";
    echo "<li><strong>Information:</strong> Country of issue, validity</li>";
    echo "<li><strong>HR Benefit:</strong> Work authorization assessment</li>";
    echo "<li><strong>Visa Requirements:</strong> Determines permit needs</li>";
    echo "</ul>";
    echo "</div>";
    echo "</div>";
    
    echo "</div>";
    
    echo "<h3 style='color: #495057;'>🎯 Smart Logic Features:</h3>";
    echo "<div style='background: rgba(108, 117, 125, 0.1); padding: 20px; border-radius: 8px; margin: 20px 0;'>";
    echo "<div style='color: #495057;'>";
    echo "<ul>";
    echo "<li><strong>Automatic Detection:</strong> Recognizes 'South African', 'South Africa', 'SA', 'RSA' variations</li>";
    echo "<li><strong>Priority Display:</strong> Shows most relevant document first</li>";
    echo "<li><strong>Secondary Information:</strong> Includes additional documents when available</li>";
    echo "<li><strong>Clear Labeling:</strong> Distinct labels for 'South African ID' vs 'Passport Number'</li>";
    echo "<li><strong>HR Efficiency:</strong> Instant document type recognition</li>";
    echo "<li><strong>Compliance Ready:</strong> Supports work authorization verification</li>";
    echo "</ul>";
    echo "</div>";
    echo "</div>";
    
    echo "</div>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}

echo "<div style='text-align: center; margin: 40px 0; padding: 20px; background: #d4edda; border-radius: 8px;'>";
echo "<h2 style='color: #155724;'>✅ Smart Document Display Complete!</h2>";
echo "<p style='color: #155724; margin: 15px 0;'><strong>HR teams now see the most relevant identification document based on candidate nationality</strong></p>";
echo "<div style='color: #155724;'>";
echo "<p>🇿🇦 <strong>South African candidates:</strong> South African ID number prominently displayed</p>";
echo "<p>🌍 <strong>Foreign nationals:</strong> Passport number prominently displayed</p>";
echo "</div>";
echo "</div>";

echo "</div></body></html>";
?>