<?php
// Simple syntax test for bulk_download.php
echo "Testing PHP syntax for bulk_download.php...\n";

// Test the problematic line that was fixed
$index = 0;
$cert_name = "AWS_Certification";
$cert_extension = "pdf";

// This was the problematic line (now fixed):
$cert_filename = "Certificate_" . ($index + 1) . "_{$cert_name}.{$cert_extension}";

echo "Generated filename: " . $cert_filename . "\n";
echo "Expected: Certificate_1_AWS_Certification.pdf\n";

// Test some other similar constructions
$test_cases = [
    ['index' => 0, 'name' => 'Java_Developer', 'ext' => 'pdf'],
    ['index' => 1, 'name' => 'Project_Management', 'ext' => 'jpg'],
    ['index' => 4, 'name' => 'SQL_Database', 'ext' => 'png']
];

echo "\nTesting multiple cases:\n";
foreach ($test_cases as $case) {
    $filename = "Certificate_" . ($case['index'] + 1) . "_{$case['name']}.{$case['ext']}";
    echo "Index {$case['index']} -> {$filename}\n";
}

echo "\nSyntax test completed successfully!\n";
?>