<?php
// Test to verify visibility badges are working
echo "Testing job visibility badges...\n\n";

try {
    // Capture output instead of displaying directly
    ob_start();
    
    // Include the jobs page
    $_GET = []; // Clear any GET parameters
    include 'jobs.php';
    
    $output = ob_get_contents();
    ob_end_clean();
    
    // Check if output contains visibility badge elements
    $tests = [
        'Contains Internal badge class' => strpos($output, 'job-badge internal') !== false || 
                                          strpos($output, 'job-badge external') !== false || 
                                          strpos($output, 'job-badge both') !== false,
        'Contains visibility icons' => strpos($output, 'fa-building') !== false || 
                                      strpos($output, 'fa-globe') !== false || 
                                      strpos($output, 'fa-users') !== false,
        'Contains visibility text' => strpos($output, 'Internal Only') !== false || 
                                     strpos($output, 'External Only') !== false || 
                                     strpos($output, 'Internal & External') !== false
    ];
    
    echo "✅ Visibility Badge Tests:\n";
    echo "==========================\n";
    foreach ($tests as $test => $passed) {
        echo ($passed ? "✅" : "❌") . " {$test}\n";
    }
    
    // Count how many job cards have visibility badges
    $internal_count = substr_count($output, 'Internal Only');
    $external_count = substr_count($output, 'External Only');  
    $both_count = substr_count($output, 'Internal & External');
    
    echo "\n📊 Badge Distribution:\n";
    echo "======================\n";
    echo "Internal Only: {$internal_count} jobs\n";
    echo "External Only: {$external_count} jobs\n";
    echo "Internal & External: {$both_count} jobs\n";
    
    $total_badges = $internal_count + $external_count + $both_count;
    echo "Total jobs with visibility badges: {$total_badges}\n";
    
    if (all_tests_passed($tests) && $total_badges > 0) {
        echo "\n🎉 SUCCESS: Job visibility badges are working correctly!\n";
        echo "📍 Visit: http://localhost/recruit/jobs.php to see the badges\n";
    } else {
        echo "\n⚠️ Some visibility tests failed or no badges found.\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error testing visibility badges: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . " | Line: " . $e->getLine() . "\n";
}

function all_tests_passed($tests) {
    foreach ($tests as $passed) {
        if (!$passed) return false;
    }
    return true;
}

echo "\n" . str_repeat("=", 50) . "\n";
echo "Job Visibility Features Added:\n";
echo "• Internal Only jobs (red badge with building icon)\n";
echo "• External Only jobs (green badge with globe icon)\n";
echo "• Internal & External jobs (yellow badge with users icon)\n";
echo "• Color-coded badges for easy identification\n";
?>