<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

echo "🇿🇦 Updating Sample Candidates to South African\n";
echo "===============================================\n\n";

try {
    // Update some existing candidates to be South African with SA ID numbers
    $sa_updates = [
        [
            'name' => 'masande ndyaluvane',
            'nationality' => 'South African',
            'id_number' => '8506291234567'
        ],
        [
            'name' => 'John Smith', 
            'nationality' => 'British',
            'passport_number' => 'GB123456789'
        ]
    ];
    
    foreach ($sa_updates as $update) {
        // Find candidate by name
        $stmt = $db->prepare("SELECT id FROM candidates WHERE LOWER(CONCAT(first_name, ' ', last_name)) = LOWER(?) LIMIT 1");
        $stmt->execute([$update['name']]);
        $candidate = $stmt->fetch();
        
        if ($candidate) {
            $update_sql = "UPDATE candidates SET nationality = ?";
            $params = [$update['nationality']];
            
            if (isset($update['id_number'])) {
                $update_sql .= ", id_number = ?";
                $params[] = $update['id_number'];
            }
            
            if (isset($update['passport_number'])) {
                $update_sql .= ", passport_number = ?";
                $params[] = $update['passport_number'];
            }
            
            $update_sql .= " WHERE id = ?";
            $params[] = $candidate['id'];
            
            $update_stmt = $db->prepare($update_sql);
            $update_stmt->execute($params);
            
            echo "✅ Updated {$update['name']} → {$update['nationality']}\n";
            if (isset($update['id_number'])) {
                echo "   📋 Added SA ID: {$update['id_number']}\n";
            }
            if (isset($update['passport_number'])) {
                echo "   🛂 Added Passport: {$update['passport_number']}\n";
            }
        } else {
            echo "⚠️ Candidate '{$update['name']}' not found\n";
        }
    }
    
    echo "\n📊 Sample Data Summary:\n";
    echo "======================\n";
    
    // Show current nationality distribution
    $stmt = $db->query("SELECT nationality, COUNT(*) as count FROM candidates WHERE nationality IS NOT NULL GROUP BY nationality");
    $nationalities = $stmt->fetchAll();
    
    foreach ($nationalities as $nat) {
        $flag = ($nat['nationality'] === 'South African') ? '🇿🇦' : '🌍';
        echo "{$flag} {$nat['nationality']}: {$nat['count']} candidate(s)\n";
    }
    
} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n🎯 HR Testing Ready!\n";
echo "==================\n";
echo "The system will now:\n";
echo "• Display SA ID for South African candidates\n";
echo "• Display Passport Number for foreign nationals\n";
echo "• Show appropriate documents in bulk downloads\n";
?>