<?php
require_once '../config/config.php';
requireLogin('admin');

$database = new Database();
$db = $database->getConnection();

$company_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if (!$company_id) {
    header('Location: companies.php');
    exit();
}

// Get company details
$stmt = $db->prepare("SELECT * FROM companies WHERE id = ?");
$stmt->execute([$company_id]);
$company = $stmt->fetch();

if (!$company) {
    header('Location: companies.php');
    exit();
}

// Get company users
$stmt = $db->prepare("
    SELECT * FROM company_users 
    WHERE company_id = ? 
    ORDER BY is_primary DESC, created_at ASC
");
$stmt->execute([$company_id]);
$company_users = $stmt->fetchAll();

// Get company jobs count
$stmt = $db->prepare("SELECT COUNT(*) as job_count FROM jobs WHERE company_id = ?");
$stmt->execute([$company_id]);
$job_stats = $stmt->fetch();

// Get recent jobs
$stmt = $db->prepare("
    SELECT j.*, jc.name as category_name, cu.name as posted_by
    FROM jobs j 
    LEFT JOIN job_categories jc ON j.category_id = jc.id
    LEFT JOIN company_users cu ON j.company_user_id = cu.id
    WHERE j.company_id = ? 
    ORDER BY j.created_at DESC 
    LIMIT 5
");
$stmt->execute([$company_id]);
$recent_jobs = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Company - <?php echo htmlspecialchars($company['name']); ?> - <?php echo SITE_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand" href="../index.php">
                <i class="fas fa-briefcase me-2"></i><?php echo SITE_NAME; ?>
            </a>
            
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3">
                    Welcome, <?php echo htmlspecialchars($_SESSION['username']); ?>
                </span>
                <a class="nav-link" href="../auth/logout.php">
                    <i class="fas fa-sign-out-alt me-1"></i>Logout
                </a>
            </div>
        </div>
    </nav>

    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-3 col-lg-2 sidebar">
                <div class="position-sticky">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link" href="dashboard.php">
                                <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="companies.php">
                                <i class="fas fa-building me-2"></i>Manage Companies
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="candidates.php">
                                <i class="fas fa-users me-2"></i>Manage Candidates
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="jobs.php">
                                <i class="fas fa-briefcase me-2"></i>Manage Jobs
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="categories.php">
                                <i class="fas fa-tags me-2"></i>Job Categories
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="applications.php">
                                <i class="fas fa-file-alt me-2"></i>Applications
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="admin-users.php">
                                <i class="fas fa-user-shield me-2"></i>Admin Users
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <!-- Main Content -->
            <main class="col-md-9 col-lg-10 px-md-4">
                <div class="py-4">
                    <!-- Breadcrumb -->
                    <nav aria-label="breadcrumb" class="mb-4">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="companies.php">Companies</a></li>
                            <li class="breadcrumb-item active"><?php echo htmlspecialchars($company['name']); ?></li>
                        </ol>
                    </nav>

                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h1 class="h2">
                            <i class="fas fa-building me-2"></i><?php echo htmlspecialchars($company['name']); ?>
                        </h1>
                        <div>
                            <a href="companies.php" class="btn btn-outline-secondary me-2">
                                <i class="fas fa-arrow-left me-1"></i>Back to Companies
                            </a>
                            <a href="add-company-user.php?company_id=<?php echo $company['id']; ?>" class="btn btn-primary">
                                <i class="fas fa-user-plus me-1"></i>Add User
                            </a>
                        </div>
                    </div>

                    <div class="row">
                        <!-- Company Information -->
                        <div class="col-lg-8">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-info-circle me-2"></i>Company Information
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="row mb-3">
                                                <div class="col-sm-4"><strong>Company Name:</strong></div>
                                                <div class="col-sm-8"><?php echo htmlspecialchars($company['name']); ?></div>
                                            </div>
                                            
                                            <div class="row mb-3">
                                                <div class="col-sm-4"><strong>Status:</strong></div>
                                                <div class="col-sm-8">
                                                    <span class="badge status-<?php echo $company['status']; ?>">
                                                        <?php echo ucfirst($company['status']); ?>
                                                    </span>
                                                </div>
                                            </div>
                                            
                                            <?php if ($company['phone']): ?>
                                            <div class="row mb-3">
                                                <div class="col-sm-4"><strong>Phone:</strong></div>
                                                <div class="col-sm-8"><?php echo htmlspecialchars($company['phone']); ?></div>
                                            </div>
                                            <?php endif; ?>
                                            
                                            <?php if ($company['website']): ?>
                                            <div class="row mb-3">
                                                <div class="col-sm-4"><strong>Website:</strong></div>
                                                <div class="col-sm-8">
                                                    <a href="<?php echo htmlspecialchars($company['website']); ?>" target="_blank">
                                                        <?php echo htmlspecialchars($company['website']); ?>
                                                        <i class="fas fa-external-link-alt ms-1"></i>
                                                    </a>
                                                </div>
                                            </div>
                                            <?php endif; ?>
                                            
                                            <?php if ($company['address']): ?>
                                            <div class="row mb-3">
                                                <div class="col-sm-4"><strong>Address:</strong></div>
                                                <div class="col-sm-8"><?php echo nl2br(htmlspecialchars($company['address'])); ?></div>
                                            </div>
                                            <?php endif; ?>
                                            
                                            <div class="row mb-3">
                                                <div class="col-sm-4"><strong>Registered:</strong></div>
                                                <div class="col-sm-8"><?php echo formatDate($company['created_at']); ?></div>
                                            </div>
                                            
                                            <div class="row mb-3">
                                                <div class="col-sm-4"><strong>Total Jobs:</strong></div>
                                                <div class="col-sm-8"><?php echo $job_stats['job_count']; ?></div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-4 text-center">
                                            <div class="company-logo-large mb-3">
                                                <?php if ($company['logo']): ?>
                                                    <img src="<?php echo UPLOAD_URL . 'logos/' . $company['logo']; ?>" 
                                                         alt="Company Logo" class="img-fluid" style="max-width: 150px; max-height: 150px;">
                                                <?php else: ?>
                                                    <div class="bg-light d-flex align-items-center justify-content-center" 
                                                         style="width: 150px; height: 150px; margin: 0 auto;">
                                                        <i class="fas fa-building text-muted fa-3x"></i>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <?php if ($company['description']): ?>
                                    <div class="row">
                                        <div class="col-12">
                                            <strong>Description:</strong>
                                            <p class="mt-2"><?php echo nl2br(htmlspecialchars($company['description'])); ?></p>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Contact Person -->
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-user-tie me-2"></i>Contact Person
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-sm-3"><strong>Name:</strong></div>
                                        <div class="col-sm-9"><?php echo htmlspecialchars($company['contact_person_name']); ?></div>
                                    </div>
                                    
                                    <div class="row mb-3">
                                        <div class="col-sm-3"><strong>Email:</strong></div>
                                        <div class="col-sm-9">
                                            <a href="mailto:<?php echo htmlspecialchars($company['contact_person_email']); ?>">
                                                <?php echo htmlspecialchars($company['contact_person_email']); ?>
                                            </a>
                                        </div>
                                    </div>
                                    
                                    <?php if ($company['contact_person_phone']): ?>
                                    <div class="row mb-3">
                                        <div class="col-sm-3"><strong>Phone:</strong></div>
                                        <div class="col-sm-9"><?php echo htmlspecialchars($company['contact_person_phone']); ?></div>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($company['contact_person_position']): ?>
                                    <div class="row">
                                        <div class="col-sm-3"><strong>Position:</strong></div>
                                        <div class="col-sm-9"><?php echo htmlspecialchars($company['contact_person_position']); ?></div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Sidebar Info -->
                        <div class="col-lg-4">
                            <!-- Company Users -->
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-users me-2"></i>Company Users (<?php echo count($company_users); ?>)
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <?php if (empty($company_users)): ?>
                                        <p class="text-muted">No users found.</p>
                                    <?php else: ?>
                                        <?php foreach ($company_users as $user): ?>
                                            <div class="d-flex align-items-center mb-3">
                                                <div class="flex-grow-1">
                                                    <h6 class="mb-0">
                                                        <?php echo htmlspecialchars($user['name']); ?>
                                                        <?php if ($user['is_primary']): ?>
                                                            <span class="badge bg-primary ms-1">Primary</span>
                                                        <?php endif; ?>
                                                    </h6>
                                                    <small class="text-muted"><?php echo htmlspecialchars($user['email']); ?></small>
                                                    <?php if ($user['position']): ?>
                                                        <br><small class="text-muted"><?php echo htmlspecialchars($user['position']); ?></small>
                                                    <?php endif; ?>
                                                </div>
                                                <span class="badge status-<?php echo $user['status']; ?>">
                                                    <?php echo ucfirst($user['status']); ?>
                                                </span>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Recent Jobs -->
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-briefcase me-2"></i>Recent Jobs
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <?php if (empty($recent_jobs)): ?>
                                        <p class="text-muted">No jobs posted yet.</p>
                                    <?php else: ?>
                                        <?php foreach ($recent_jobs as $job): ?>
                                            <div class="mb-3">
                                                <h6 class="mb-1"><?php echo htmlspecialchars($job['title']); ?></h6>
                                                <small class="text-muted">
                                                    <?php echo formatDate($job['created_at']); ?>
                                                    <?php if ($job['posted_by']): ?>
                                                        • by <?php echo htmlspecialchars($job['posted_by']); ?>
                                                    <?php endif; ?>
                                                </small>
                                                <br>
                                                <span class="badge status-<?php echo $job['status']; ?>">
                                                    <?php echo ucfirst($job['status']); ?>
                                                </span>
                                                <?php if ($job['category_name']): ?>
                                                    <span class="badge bg-secondary">
                                                        <?php echo htmlspecialchars($job['category_name']); ?>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; ?>
                                        
                                        <div class="text-center mt-3">
                                            <a href="jobs.php?company=<?php echo $company['id']; ?>" class="btn btn-outline-primary btn-sm">
                                                View All Jobs
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>