<?php
require_once '../config/config.php';
require_once '../includes/audit_trail.php';

// Log logout if user was logged in
if (isLoggedIn()) {
    $database = new Database();
    $db = $database->getConnection();
    $auditTrail = new AuditTrail($db);
    
    $auditTrail->logLogout(
        $_SESSION['user_id'], 
        $_SESSION['user_type'], 
        $_SESSION['user_email']
    );
}

// Destroy all session data
session_destroy();

// Redirect to home page
redirect('../index.php');
?>