<?php
require_once 'config/config.php';

try {
    $database = new Database();
    $db = $database->getConnection();
    
    echo "Adding longlisted status to job_applications table...\n";
    
    // Update the ENUM to include longlisted status
    $sql = "ALTER TABLE job_applications 
            MODIFY COLUMN status ENUM('applied', 'longlisted', 'shortlisted', 'interviewed', 'hired', 'rejected') DEFAULT 'applied'";
    
    $db->exec($sql);
    
    echo "✓ Successfully added 'longlisted' status to job_applications table\n";
    echo "✓ The recruitment process now supports: applied → longlisted → shortlisted → interviewed → hired/rejected\n";
    
} catch (PDOException $e) {
    echo "✗ Error updating database: " . $e->getMessage() . "\n";
}
?>