<?php
// Test companies page functionality
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

try {
    // Test the companies query from admin/companies.php
    $stmt = $db->prepare("
        SELECT c.*, COUNT(cu.id) as user_count 
        FROM companies c 
        LEFT JOIN company_users cu ON c.id = cu.company_id AND cu.status = 'active'
        GROUP BY c.id 
        ORDER BY c.created_at DESC
    ");
    $stmt->execute();
    $companies = $stmt->fetchAll();
    
    echo "Companies query successful!\n";
    echo "Found " . count($companies) . " companies:\n";
    
    foreach ($companies as $company) {
        echo "- {$company['name']} (Users: {$company['user_count']})\n";
        echo "  Contact: {$company['contact_person_name']} ({$company['contact_person_email']})\n";
        echo "  Logo: {$company['logo']}\n";
        echo "  Status: {$company['status']}\n\n";
    }
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>