<?php
require_once 'config/config.php';

echo "<h2>Email Test - " . SITE_NAME . "</h2>";

// Test basic PHP mail function
$test_email = "test@example.com"; // Change this to your email
$subject = "Test Email from " . SITE_NAME;
$message = "This is a test email to verify email functionality.";
$headers = "From: " . SITE_NAME . " <noreply@localhost>\r\n";
$headers .= "Content-Type: text/html; charset=UTF-8\r\n";

echo "<h3>Testing PHP mail() function:</h3>";

if (function_exists('mail')) {
    echo "✓ PHP mail() function is available<br>";
    
    // Try sending test email
    $result = mail($test_email, $subject, $message, $headers);
    
    if ($result) {
        echo "✓ mail() function returned true<br>";
        echo "Email sent to: $test_email<br>";
    } else {
        echo "✗ mail() function returned false<br>";
        echo "Email sending failed<br>";
    }
} else {
    echo "✗ PHP mail() function is not available<br>";
}

echo "<h3>Server Configuration:</h3>";
echo "SMTP: " . ini_get('SMTP') . "<br>";
echo "smtp_port: " . ini_get('smtp_port') . "<br>";
echo "sendmail_from: " . ini_get('sendmail_from') . "<br>";
echo "sendmail_path: " . ini_get('sendmail_path') . "<br>";

echo "<h3>Testing EmailService:</h3>";

try {
    require_once 'includes/email_service.php';
    $database = new Database();
    $db = $database->getConnection();
    $emailService = new EmailService($db);
    
    // Test basic email
    $result = $emailService->testEmail($test_email);
    
    if ($result) {
        echo "✓ EmailService test successful<br>";
    } else {
        echo "✗ EmailService test failed<br>";
    }
    
    echo "<h3>Testing Notification System:</h3>";
    
    require_once 'includes/notification_system.php';
    $notificationSystem = new NotificationSystem($db);
    
    // Test email notification
    $result = $notificationSystem->sendEmailNotification(
        $test_email, 
        "Test Notification from " . SITE_NAME,
        "<p>This is a test notification email.</p><p>If you receive this, email notifications are working!</p>"
    );
    
    if ($result) {
        echo "✓ Notification system email test successful<br>";
    } else {
        echo "✗ Notification system email test failed<br>";
    }
    
    // Check email log
    $stmt = $db->prepare("SELECT * FROM email_notifications ORDER BY created_at DESC LIMIT 5");
    $stmt->execute();
    $emails = $stmt->fetchAll();
    
    echo "<h4>Recent Email Log:</h4>";
    if (empty($emails)) {
        echo "No emails in log<br>";
    } else {
        echo "<table border='1'>";
        echo "<tr><th>To</th><th>Subject</th><th>Status</th><th>Created</th><th>Error</th></tr>";
        foreach ($emails as $email) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($email['to_email']) . "</td>";
            echo "<td>" . htmlspecialchars(substr($email['subject'], 0, 30)) . "...</td>";
            echo "<td>" . $email['status'] . "</td>";
            echo "<td>" . $email['created_at'] . "</td>";
            echo "<td>" . htmlspecialchars($email['error_message'] ?? '') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
} catch (Exception $e) {
    echo "✗ Error testing notification system: " . $e->getMessage() . "<br>";
}

echo "<h3>Recommendations:</h3>";
echo "<p>If emails are not working, try these solutions:</p>";
echo "<ol>";
echo "<li>Configure XAMPP to use a real SMTP server (Gmail, SendGrid, etc.)</li>";
echo "<li>Use PHPMailer library instead of PHP mail() function</li>";
echo "<li>Check Windows firewall settings</li>";
echo "<li>Use a local mail server like hMailServer</li>";
echo "</ol>";
?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; }
table { border-collapse: collapse; margin: 10px 0; }
th, td { padding: 8px; text-align: left; }
th { background-color: #f2f2f2; }
</style>